/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.spigot.sidebar.v1_21_R3;

import com.andrei1058.spigot.sidebar.PlaceholderProvider;
import com.andrei1058.spigot.sidebar.PlayerTab;
import com.andrei1058.spigot.sidebar.SidebarLine;
import com.andrei1058.spigot.sidebar.VersionedTabGroup;
import com.andrei1058.spigot.sidebar.WrappedSidebar;
import dev.andrei1058.spigot.sidebar.cmn1.PlayerListImplCmn1;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerListImpl
extends ScoreboardTeam
implements VersionedTabGroup {
    private static PacketPlayOutScoreboardTeam.a cachedScoreboardActionA;
    private static PacketPlayOutScoreboardTeam.a cachedScoreboardActionB;
    private final PlayerListImplCmn1 handle;

    public PlayerListImpl(@NotNull WrappedSidebar sidebar, String identifier, SidebarLine prefix, SidebarLine suffix, PlayerTab.PushingRule pushingRule, PlayerTab.NameTagVisibility nameTagVisibility, @Nullable Collection<PlaceholderProvider> placeholders) {
        super(null, identifier);
        this.handle = new PlayerListImplCmn1(sidebar, identifier, prefix, suffix, pushingRule, nameTagVisibility, placeholders);
        if (null == cachedScoreboardActionA && null == (cachedScoreboardActionA = (PacketPlayOutScoreboardTeam.a)PlayerListImpl.getScoreboardAction("ADD"))) {
            cachedScoreboardActionA = (PacketPlayOutScoreboardTeam.a)PlayerListImpl.getScoreboardAction("a");
        }
        if (null == cachedScoreboardActionB && null == (cachedScoreboardActionB = (PacketPlayOutScoreboardTeam.a)PlayerListImpl.getScoreboardAction("REMOVE"))) {
            cachedScoreboardActionB = (PacketPlayOutScoreboardTeam.a)PlayerListImpl.getScoreboardAction("b");
        }
    }

    public void sendCreateToPlayer(Player player) {
        this.sendPacket(player, (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this, (boolean)true));
    }

    public void sendUserCreateToReceivers(@NotNull Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this, (String)player.getName(), (PacketPlayOutScoreboardTeam.a)cachedScoreboardActionA);
        this.handle.getSidebar().getReceivers().forEach(r -> this.sendPacket((Player)r, (Packet<?>)packetPlayOutScoreboardTeam));
    }

    public void sendUpdateToReceivers() {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this, (boolean)false);
        this.handle.getSidebar().getReceivers().forEach(r -> this.sendPacket((Player)r, (Packet<?>)packetPlayOutScoreboardTeam));
    }

    public void sendRemoveToReceivers() {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this);
        this.handle.getSidebar().getReceivers().forEach(r -> this.sendPacket((Player)r, (Packet<?>)packetPlayOutScoreboardTeam));
    }

    public boolean refreshContent() {
        return this.handle.refreshContent();
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().f.b(packet);
    }

    public void add(@NotNull Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this, (String)player.getName(), (PacketPlayOutScoreboardTeam.a)cachedScoreboardActionA);
        this.handle.getSidebar().getReceivers().forEach(r -> this.sendPacket((Player)r, (Packet<?>)packetPlayOutScoreboardTeam));
    }

    public void remove(@NotNull Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this, (String)player.getName(), (PacketPlayOutScoreboardTeam.a)cachedScoreboardActionB);
        this.handle.getSidebar().getReceivers().forEach(r -> this.sendPacket((Player)r, (Packet<?>)packetPlayOutScoreboardTeam));
    }

    public void setSubject(@Nullable Player player) {
        this.handle.setPapiSubject(player);
    }

    @Nullable
    public Player getSubject() {
        return this.handle.getPapiSubject();
    }

    public void setPushingRule(@NotNull PlayerTab.PushingRule rule) {
        this.handle.setPushingRule(this.handle.toNmsPushing(rule));
        if (null != this.handle.getId()) {
            this.sendUpdateToReceivers();
        }
    }

    public void setNameTagVisibility(@NotNull PlayerTab.NameTagVisibility nameTagVisibility) {
        this.handle.setNameTagVisibility(this.handle.toNmsTagVisibility(nameTagVisibility));
        if (null != this.handle.getId()) {
            this.sendUpdateToReceivers();
        }
    }

    public String getIdentifier() {
        return this.handle.getId();
    }

    private static Object getScoreboardAction(String action) {
        try {
            Class<?> cls = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam$a");
            for (Object obj : cls.getEnumConstants()) {
                try {
                    Method m = cls.getMethod("name", new Class[0]);
                    String name = (String)m.invoke(obj, new Object[0]);
                    if (!action.equals(name)) continue;
                    return obj;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("Something went wrong... please report this to SidebarLib by andrei1058");
    }

    @NotNull
    public IChatBaseComponent e() {
        return this.handle.getPrefixComp();
    }

    @NotNull
    public IChatBaseComponent f() {
        return this.handle.getSuffixComp();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public IChatMutableComponent d(IChatBaseComponent var0) {
        return IChatBaseComponent.b((String)(this.handle.getPrefixComp().toString() + var0.getString() + this.handle.getSuffixComp().toString()));
    }
}

