/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.spigot.sidebar.v1_18_R2;

import com.andrei1058.spigot.sidebar.PlaceholderProvider;
import com.andrei1058.spigot.sidebar.ScoreLine;
import com.andrei1058.spigot.sidebar.SidebarLine;
import com.andrei1058.spigot.sidebar.SidebarObjective;
import com.andrei1058.spigot.sidebar.WrappedSidebar;
import java.util.Collection;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidebarImpl
extends WrappedSidebar {
    public SidebarImpl(@NotNull SidebarLine title, @NotNull Collection<SidebarLine> lines, Collection<PlaceholderProvider> placeholderProvider) {
        super(title, lines, placeholderProvider);
    }

    public ScoreLine createScore(SidebarLine line, int score, String color) {
        return new NarniaScoreLine(line, score, color);
    }

    public SidebarObjective createObjective(String name, IScoreboardCriteria iScoreboardCriteria, SidebarLine title, int type) {
        return new NarniaSidebarObjective(name, iScoreboardCriteria, title, type);
    }

    public class NarniaScoreLine
    extends ScoreboardScore
    implements ScoreLine,
    Comparable<ScoreLine> {
        private int score;
        private ChatComponentText prefixComp;
        private ChatComponentText suffixComp;
        private final TeamLine team;
        private SidebarLine text;

        public NarniaScoreLine(SidebarLine text, @NotNull int score, String color) {
            super(null, (ScoreboardObjective)SidebarImpl.this.getSidebarObjective(), color);
            this.prefixComp = new ChatComponentText("");
            this.suffixComp = new ChatComponentText("");
            this.score = score;
            this.text = text;
            this.team = new TeamLine(color);
        }

        public SidebarLine getLine() {
            return this.text;
        }

        public void setLine(SidebarLine line) {
            this.text = line;
        }

        public int getScoreAmount() {
            return this.score;
        }

        public void setScoreAmount(int score) {
            this.b(score);
        }

        public void sendCreateToAllReceivers() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            SidebarImpl.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardTeam));
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, SidebarImpl.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            SidebarImpl.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardScore));
        }

        public void sendCreate(Player player) {
            PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            conn.a((Packet)packetPlayOutScoreboardTeam);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, SidebarImpl.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            conn.a((Packet)packetPlayOutScoreboardScore);
        }

        public void sendRemove(Player player) {
            PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, SidebarImpl.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            conn.a((Packet)packetPlayOutScoreboardTeam);
            conn.a((Packet)packetPlayOutScoreboardScore);
        }

        public void sendRemoveToAllReceivers() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team);
            SidebarImpl.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardTeam));
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, SidebarImpl.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            SidebarImpl.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardScore));
        }

        public void sendUpdate(Player player) {
            PacketPlayOutScoreboardTeam packetTeamUpdate = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)false);
            ((CraftPlayer)player).getHandle().b.a((Packet)packetTeamUpdate);
        }

        @Contract(pure=true)
        public boolean setContent(@NotNull SidebarLine line) {
            String content = line.getTrimReplacePlaceholders(SidebarImpl.this.getReceivers().isEmpty() ? null : (Player)SidebarImpl.this.getReceivers().getFirst(), null, SidebarImpl.this.getPlaceholders());
            String oldPrefix = this.prefixComp.h();
            String oldSuffix = this.suffixComp.h();
            if (content.length() > 64) {
                this.prefixComp = new ChatComponentText(content.substring(0, 64));
                if (this.prefixComp.h().charAt(63) == '\u00a7') {
                    this.prefixComp = new ChatComponentText(content.substring(0, 63));
                    this.setSuffix(content.substring(63));
                } else {
                    this.setSuffix(content.substring(64));
                }
            } else {
                this.prefixComp = new ChatComponentText(content);
                this.suffixComp = new ChatComponentText("");
            }
            return !oldPrefix.equals(this.prefixComp.h()) || !oldSuffix.equals(this.suffixComp.h());
        }

        public void setSuffix(@NotNull String secondPart) {
            if (((String)secondPart).isEmpty()) {
                this.suffixComp = new ChatComponentText("");
                return;
            }
            secondPart = ChatColor.getLastColors((String)this.prefixComp.h()) + (String)secondPart;
            this.suffixComp = new ChatComponentText((String)(((String)secondPart).length() > 64 ? ((String)secondPart).substring(0, 64) : secondPart));
        }

        public void sendUpdateToAllReceivers() {
            PacketPlayOutScoreboardTeam packetTeamUpdate = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)false);
            SidebarImpl.this.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().b.a((Packet)packetTeamUpdate));
        }

        @Override
        public int compareTo(@NotNull ScoreLine o) {
            return Integer.compare(this.score, o.getScoreAmount());
        }

        public void b(int score) {
            this.score = score;
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, ((ScoreboardObjective)SidebarImpl.this.getSidebarObjective()).b(), this.e(), score);
            SidebarImpl.this.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().b.a((Packet)packetPlayOutScoreboardScore));
        }

        public int b() {
            return this.score;
        }

        public void c() {
        }

        public void a(int i) {
        }

        public void a() {
        }

        public String getColor() {
            return this.team.b().charAt(0) == '\u00a7' ? this.team.b() : "\u00a7" + this.team.b();
        }

        public boolean refreshContent() {
            return this.setContent(this.getLine());
        }

        private class TeamLine
        extends ScoreboardTeam {
            public TeamLine(String color) {
                super(null, color);
                this.g().add(color);
            }

            @Contract(value=" -> new", pure=true)
            @NotNull
            public IChatBaseComponent e() {
                return NarniaScoreLine.this.prefixComp;
            }

            public void b(@Nullable IChatBaseComponent var0) {
            }

            public void c(@Nullable IChatBaseComponent var0) {
            }

            @Contract(value=" -> new", pure=true)
            @NotNull
            public IChatBaseComponent f() {
                return NarniaScoreLine.this.suffixComp;
            }

            public void a(boolean var0) {
            }

            public void b(boolean var0) {
            }

            public void a(ScoreboardTeamBase.EnumNameTagVisibility var0) {
            }

            public void a(ScoreboardTeamBase.EnumTeamPush var0) {
            }

            public void a(EnumChatFormat var0) {
            }

            @Contract(value="_ -> new", pure=true)
            @NotNull
            public IChatMutableComponent d(IChatBaseComponent var0) {
                return new ChatComponentText(NarniaScoreLine.this.prefixComp.h() + String.valueOf(var0) + NarniaScoreLine.this.suffixComp.h());
            }
        }
    }

    protected class NarniaSidebarObjective
    extends ScoreboardObjective
    implements SidebarObjective {
        private SidebarLine displayName;
        private ChatComponentText displayNameComp;
        private final int type;

        public NarniaSidebarObjective(String name, IScoreboardCriteria criteria, SidebarLine displayName, int type) {
            super(null, name, criteria, (IChatBaseComponent)new ChatComponentText(name), IScoreboardCriteria.EnumScoreboardHealthDisplay.a);
            this.displayNameComp = new ChatComponentText("");
            this.displayName = displayName;
            this.type = type;
        }

        public void setTitle(SidebarLine title) {
            this.displayName = title;
        }

        public SidebarLine getTitle() {
            return this.displayName;
        }

        public void sendCreate(Player player) {
            this.sendCreate(((CraftPlayer)player).getHandle().b);
        }

        public void sendRemove(Player player) {
            this.sendRemove(((CraftPlayer)player).getHandle().b);
        }

        public String getName() {
            return this.b();
        }

        public boolean refreshTitle() {
            String newTitle = this.displayName.getTrimReplacePlaceholders(SidebarImpl.this.getReceivers().isEmpty() ? null : (Player)SidebarImpl.this.getReceivers().getFirst(), Integer.valueOf(32), SidebarImpl.this.getPlaceholders());
            if (newTitle.equals(this.displayNameComp.h())) {
                return false;
            }
            this.displayNameComp = new ChatComponentText(newTitle);
            return true;
        }

        public IChatBaseComponent d() {
            return this.displayNameComp;
        }

        public void a(IChatBaseComponent var0) {
        }

        public IChatBaseComponent e() {
            return new ChatComponentText(this.d().a());
        }

        public void a(IScoreboardCriteria.EnumScoreboardHealthDisplay var0) {
        }

        private void sendCreate(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 0);
            playerConnection.a((Packet)packetPlayOutScoreboardObjective);
            PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective = new PacketPlayOutScoreboardDisplayObjective(this.type, (ScoreboardObjective)this);
            playerConnection.a((Packet)packetPlayOutScoreboardDisplayObjective);
            if (this.b().equalsIgnoreCase("health")) {
                PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective2 = new PacketPlayOutScoreboardDisplayObjective(0, (ScoreboardObjective)this);
                playerConnection.a((Packet)packetPlayOutScoreboardDisplayObjective2);
            }
        }

        public void sendUpdate() {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 2);
            SidebarImpl.this.getReceivers().forEach(player -> ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutScoreboardObjective));
        }

        public void sendRemove(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 1);
            playerConnection.a((Packet)packetPlayOutScoreboardObjective);
        }
    }
}

